<?php

	add_filter('pt-ocdi/disable_pt_branding', '__return_true');
	
	add_filter('pt-ocdi/regenerate_thumbnails_in_content_import', '__return_false');


/* ============================================================================================================================================= */


	function efor_ocdi_time_for_one_ajax_call()
	{
		return 10;
	}
	
	add_action('pt-ocdi/time_for_one_ajax_call', 'efor_ocdi_time_for_one_ajax_call');


/* ============================================================================================================================================= */


	function efor_ocdi_plugin_page_setup($default_settings)
	{
		$default_settings['capability']  = 'import';
		$default_settings['parent_slug'] = 'themes.php';
		$default_settings['menu_slug']   = 'efor-import-theme-demos';
		$default_settings['menu_title']  = esc_html__('Import Theme Demos' , 'efor');
		$default_settings['page_title']  = esc_html__('One Click Demo Import' , 'efor');
		
		return $default_settings;
	}

	add_filter('ocdi/plugin_page_setup', 'efor_ocdi_plugin_page_setup');


/* ============================================================================================================================================= */


	function efor_ocdi_plugin_intro_text($default_text)
	{
		$default_text .= '<div class="notice notice-warning">';
		$default_text .= 	'<p>';
		$default_text .= 		'<b><span style="color: #ff0000;">' . esc_html__('Important', 'efor') . '</span></b>';
		$default_text .= 		'<br>';
		$default_text .= 		'<b>' . '<a target="_blank" href="https://elementor.com/help/requirements/">' . esc_html__('Please check out here for the system requirements you need in order to import demo data and use Elementor.', 'efor') . '</a> ' . esc_html__('(If you are not sure whether or not your server support this, contact your host.)', 'efor') . '</b>';
		$default_text .= 	'</p>';
		$default_text .= '</div>';
		
		return $default_text;
	}
	
	add_filter('ocdi/plugin_intro_text', 'efor_ocdi_plugin_intro_text');


/* ============================================================================================================================================= */


	function efor_after_import()
	{
		// Assign menus to their locations.
		
		$main_menu = get_term_by('name', 'MyMenu', 'nav_menu');
		
		set_theme_mod(
			'nav_menu_locations',
			array(
				'efor_theme_menu_location' => $main_menu->term_id,
			)
		);
		
		
		// Assign Homepage and Blog page.
		
		$homepage  = get_page_by_title('Home'); // Get homepage.
		$blog_page = get_page_by_title('Blog'); // Get blog page.
		
		update_option('show_on_front', 'page');
		update_option('page_on_front', $homepage->ID); // Set homepage.
		update_option('page_for_posts', $blog_page->ID); // Set blog page.
	}
	
	add_action('pt-ocdi/after_import', 'efor_after_import');


/* ============================================================================================================================================= */


	function efor_ocdi_import_files()
	{
		$theme_directory     = trailingslashit(get_template_directory());
		$theme_directory_url = trailingslashit(get_template_directory_uri());
		
		return array(
			array(
				'import_file_name'             => esc_html__('Debra Wilson', 'efor'),
				'categories'                   => array('LearnPress LMS Demos'),
				'local_import_file'            => $theme_directory     . 'admin/demo-data/01/content.xml',
				'local_import_widget_file'     => $theme_directory     . 'admin/demo-data/01/widgets.wie',
				'local_import_customizer_file' => $theme_directory     . 'admin/demo-data/01/customizer.dat',
				'import_preview_image_url'     => $theme_directory_url . 'admin/demo-data/01/screenshot.jpg',
				'preview_url'                  => 'https://themes.pixelwars.org/efor/demo-01/'
			),
			array(
				'import_file_name'             => esc_html__('John Ray Coaching', 'efor'),
				'categories'                   => array('LearnPress LMS Demos'),
				'local_import_file'            => $theme_directory     . 'admin/demo-data/02/content.xml',
				'local_import_widget_file'     => $theme_directory     . 'admin/demo-data/02/widgets.wie',
				'local_import_customizer_file' => $theme_directory     . 'admin/demo-data/02/customizer.dat',
				'import_preview_image_url'     => $theme_directory_url . 'admin/demo-data/02/screenshot.jpg',
				'preview_url'                  => 'https://themes.pixelwars.org/efor/demo-02/'
			),
			array(
				'import_file_name'             => esc_html__('Linda Cooper', 'efor'),
				'categories'                   => array('LearnPress LMS Demos'),
				'local_import_file'            => $theme_directory     . 'admin/demo-data/03/content.xml',
				'local_import_widget_file'     => $theme_directory     . 'admin/demo-data/03/widgets.wie',
				'local_import_customizer_file' => $theme_directory     . 'admin/demo-data/03/customizer.dat',
				'import_preview_image_url'     => $theme_directory_url . 'admin/demo-data/03/screenshot.jpg',
				'preview_url'                  => 'https://themes.pixelwars.org/efor/demo-03/'
			),
			array(
				'import_file_name'             => esc_html__('Richard Hopkins', 'efor'),
				'categories'                   => array('LearnPress LMS Demos'),
				'local_import_file'            => $theme_directory     . 'admin/demo-data/04/content.xml',
				'local_import_widget_file'     => $theme_directory     . 'admin/demo-data/04/widgets.wie',
				'local_import_customizer_file' => $theme_directory     . 'admin/demo-data/04/customizer.dat',
				'import_preview_image_url'     => $theme_directory_url . 'admin/demo-data/04/screenshot.jpg',
				'preview_url'                  => 'https://themes.pixelwars.org/efor/demo-04/'
			),
			array(
				'import_file_name'             => esc_html__('Stefan Hughes', 'efor'),
				'categories'                   => array('LearnPress LMS Demos'),
				'local_import_file'            => $theme_directory     . 'admin/demo-data/05/content.xml',
				'local_import_widget_file'     => $theme_directory     . 'admin/demo-data/05/widgets.wie',
				'local_import_customizer_file' => $theme_directory     . 'admin/demo-data/05/customizer.dat',
				'import_preview_image_url'     => $theme_directory_url . 'admin/demo-data/05/screenshot.jpg',
				'preview_url'                  => 'https://themes.pixelwars.org/efor/demo-05/'
			),
			array(
				'import_file_name'             => esc_html__('Judy West', 'efor'),
				'categories'                   => array('Tutor LMS Demos'),
				'local_import_file'            => $theme_directory     . 'admin/demo-data/06/content.xml',
				'local_import_widget_file'     => $theme_directory     . 'admin/demo-data/06/widgets.wie',
				'local_import_customizer_file' => $theme_directory     . 'admin/demo-data/06/customizer.dat',
				'import_preview_image_url'     => $theme_directory_url . 'admin/demo-data/06/screenshot.jpg',
				'preview_url'                  => 'https://themes.pixelwars.org/efor/demo-06/'
			),
			array(
				'import_file_name'             => esc_html__('Jay Gattuso', 'efor'),
				'categories'                   => array('Tutor LMS Demos'),
				'local_import_file'            => $theme_directory     . 'admin/demo-data/07/content.xml',
				'local_import_widget_file'     => $theme_directory     . 'admin/demo-data/07/widgets.wie',
				'local_import_customizer_file' => $theme_directory     . 'admin/demo-data/07/customizer.dat',
				'import_preview_image_url'     => $theme_directory_url . 'admin/demo-data/07/screenshot.jpg',
				'preview_url'                  => 'https://themes.pixelwars.org/efor/demo-07/'
			),
			array(
				'import_file_name'             => esc_html__('Olive Mathews', 'efor'),
				'categories'                   => array('Tutor LMS Demos'),
				'local_import_file'            => $theme_directory     . 'admin/demo-data/08/content.xml',
				'local_import_widget_file'     => $theme_directory     . 'admin/demo-data/08/widgets.wie',
				'local_import_customizer_file' => $theme_directory     . 'admin/demo-data/08/customizer.dat',
				'import_preview_image_url'     => $theme_directory_url . 'admin/demo-data/08/screenshot.jpg',
				'preview_url'                  => 'https://themes.pixelwars.org/efor/demo-08/'
			)
		);
	}
	
	add_filter('pt-ocdi/import_files', 'efor_ocdi_import_files');


?>