<?php

	require_once get_template_directory() . '/admin/class-tgm-plugin-activation.php';
	
	
	function efor_plugins()
	{
		$message  = '<div class="notice notice-warning efor-install-plugins-notice">';
		$message .= 	'<h3>' . esc_html__('Important', 'efor') . ' </h3>';
		$message .= 	'<p><b>' . esc_html__('Install only one', 'efor') . ' <abbr title="Learning Management System">' . esc_html__('LMS', 'efor') . '</abbr> ' . esc_html__('(Online Courses) plugin to avoid any conflict.', 'efor') . '</b></p>';
		$message .= 	'<ul>';
		$message .= 		'<li>' . esc_html__('Install', 'efor') . ' <b>' . esc_html__('LearnPress LMS', 'efor') . '</b> ' . esc_html__('plugin for demo: 01/02/03/04/05', 'efor') . '</li>';
		$message .= 		'<li>' . esc_html__('Install', 'efor') . ' <b>' . esc_html__('Tutor LMS', 'efor') . '</b> ' . esc_html__('plugin for demo: 06/07/08', 'efor') . '</li>';
		$message .= 	'</ul>';
		$message .= 	'<hr>';
		$message .= 	'<p><b>' . esc_html__('Note:', 'efor') . '</b> ' . '<span>' . esc_html__('If you encounter any update issue for a plugin, just deactivate it from Plugins menu and delete, then reinstall from here.', 'efor') . '</span>' . '</p>';
		$message .= '</div>';
		
		$config = array(
			'id'           => 'efor_tgmpa',
			'default_path' => "",
			'menu'         => 'efor-install-theme-plugins',
			'parent_slug'  => 'themes.php',
			'capability'   => 'edit_theme_options',
			'has_notices'  => true,
			'dismissable'  => true,
			'dismiss_msg'  => '<h2>' . esc_html__('Theme Plugins', 'efor') . '</h2>',
			'is_automatic' => true,
			'message'      => $message,
			'strings'      => array(
				'menu_title' => esc_html__('Install Theme Plugins', 'efor'),
				'page_title' => esc_html__('Install Theme Plugins', 'efor')
			)
		);
		
		$plugins = array(
			array(
				'name'               => esc_html__('Pixelwars Core', 'efor'),
				'slug'               => 'pixelwars-core',
				'source'             => get_template_directory() . '/admin/plugins/pixelwars-core.zip',
				'version'            => '4.0.1',
				'required'           => false,
				'force_activation'   => false,
				'force_deactivation' => false,
				'external_url'       => "",
				'is_callable'        => ""
			),
			array(
				'name'               => esc_html__('Pixelwars Core Shortcodes - (Optional)', 'efor'),
				'slug'               => 'pixelwars-core-shortcodes',
				'source'             => get_template_directory() . '/admin/plugins/pixelwars-core-shortcodes.zip',
				'version'            => '1.0.4',
				'required'           => false,
				'force_activation'   => false,
				'force_deactivation' => false,
				'external_url'       => "",
				'is_callable'        => ""
			),
			array(
				'name'               => esc_html__('JetElements - Addon for Elementor Page Builder', 'efor'),
				'slug'               => 'jet-elements',
				'source'             => get_template_directory() . '/admin/plugins/jet-elements.zip',
				'version'            => '2.6.5',
				'required'           => false,
				'force_activation'   => false,
				'force_deactivation' => false,
				'external_url'       => "",
				'is_callable'        => ""
			),
			array(
				'name'               => esc_html__('JetPopup - Addon for Elementor Page Builder', 'efor'),
				'slug'               => 'jet-popup',
				'source'             => get_template_directory() . '/admin/plugins/jet-popup.zip',
				'version'            => '1.5.6',
				'required'           => false,
				'force_activation'   => false,
				'force_deactivation' => false,
				'external_url'       => "",
				'is_callable'        => ""
			),
			array(
				'name'               => esc_html__('(LMS) Tutor Pro (For demo: 06/07/08)', 'efor'),
				'slug'               => 'tutor-pro',
				'source'             => get_template_directory() . '/admin/plugins/tutor-pro.zip',
				'version'            => '2.0.5',
				'required'           => false,
				'force_activation'   => false,
				'force_deactivation' => false,
				'external_url'       => "",
				'is_callable'        => ""
			),
			array(
				'name'               => esc_html__('(LMS) Tutor Certificate Builder (For demo: 06/07/08)', 'efor'),
				'slug'               => 'tutor-lms-certificate-builder',
				'source'             => get_template_directory() . '/admin/plugins/tutor-lms-certificate-builder.zip',
				'version'            => '1.0.4',
				'required'           => false,
				'force_activation'   => false,
				'force_deactivation' => false,
				'external_url'       => "",
				'is_callable'        => ""
			),
			array(
				'name'     => esc_html__('One Click Demo Import', 'efor'),
				'slug'     => 'one-click-demo-import',
				'required' => false
			),
			array(
				'name'     => esc_html__('I Recommend This', 'efor'),
				'slug'     => 'i-recommend-this',
				'required' => false
			),
			array(
				'name'     => esc_html__('Regenerate Thumbnails', 'efor'),
				'slug'     => 'regenerate-thumbnails',
				'required' => false
			),
			array(
				'name'     => esc_html__('Loco Translate', 'efor'),
				'slug'     => 'loco-translate',
				'required' => false
			),
			array(
				'name'     => esc_html__('Instagram Feed Gallery', 'efor'),
				'slug'     => 'insta-gallery',
				'required' => false
			),
			array(
				'name'     => esc_html__('Top 10 - Popular Posts', 'efor'),
				'slug'     => 'top-10',
				'required' => false
			),
			array(
				'name'     => esc_html__('MailChimp for WordPress', 'efor'),
				'slug'     => 'mailchimp-for-wp',
				'required' => false
			),
			array(
				'name'     => esc_html__('Selection Sharer', 'efor'),
				'slug'     => 'selection-sharer',
				'required' => false
			),
			array(
				'name'     => esc_html__('WPFront Scroll Top', 'efor'),
				'slug'     => 'wpfront-scroll-top',
				'required' => false
			),
			array(
				'name'     => esc_html__('(LMS) LearnPress (For demo: 01/02/03/04/05)', 'efor'),
				'slug'     => 'learnpress',
				'required' => false
			),
			array(
				'name'     => esc_html__('(LMS) Tutor (For demo: 06/07/08)', 'efor'),
				'slug'     => 'tutor',
				'required' => false
			),
			array(
				'name'     => esc_html__('Elementor Page Builder', 'efor'),
				'slug'     => 'elementor',
				'required' => false
			),
			array(
				'name'     => esc_html__('WooCommerce', 'efor'),
				'slug'     => 'woocommerce',
				'required' => false
			),
			array(
				'name'     => esc_html__('GDPR Cookie Consent Banner', 'efor'),
				'slug'     => 'uk-cookie-consent',
				'required' => false
			)
		);
		
		tgmpa($plugins, $config);
	}
	
	add_action('tgmpa_register', 'efor_plugins');
